---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
aliases:
  - ApparentForms
---

# Apparent Form (classification)

> Looks coherent locally, but hides instability at one or more embedding layers.

---

## Definition

- For some $k < n$, $⊚(R^k(∆_0))$ fails or is marginal; local views appear stable
- Surface stability masks deeper instability

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Hidden failure | Layer check | `DeepProbe`, `Audit` |
| Masked instability | State verify | `CrossCheck`, `Stress` |
| Surface stability | Interface test | `Boundary`, `Mock` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Hidden failure | Deep weakness | "Seems fine but..." |
| Masked instability | Covered problem | "Paper over cracks" |
| Surface stability | Looks good | "Fine on surface" |

### Crosswalk (bridge)

| Technical term | Humane term | Diagnostic meaning |
|---------------|-------------|-------------------|
| Layer check | Deep look | How we find hidden issues |
| State verify | True test | How we reveal masks |
| Interface test | Surface check | How we spot facades |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Metastable check | Hidden stress |
| Networks | Deep probe | Masked break |
| Cognition | Context switch | Brittle pattern |
| Systems | Layer audit | Hidden weakness |

---

## Invariants / Thresholds

Scale-dependent bounds:

### Micro Scale (ε-bounded)

| Constant | Threshold | Test |
|----------|-----------|------|
| ε | Hidden drift | Deep quantum probe |
| λV | Masked gaps | Level transition |

### Human Scale (ψA-bounded)

| Constant | Threshold | Test |
|----------|-----------|------|
| ψA | Phase masking | Context switch |
| ∇S | Hidden breaks | Stress test |

### Cosmic Scale (c-bounded)

| Constant | Threshold | Test |
|----------|-----------|------|
| c | Hidden horizon | Causal trace |
| λV | Masked void | Field probe |

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Hidden fragmentation | Deep brittleness |
| Human | λV | Masked gates | Hidden boundaries |
| Cosmic | ψA | Phase facade | False coherence |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Hidden drift | Sub-ε accumulation | Slow decay |
| Human | Masked break | Layer disconnect | Sudden failure |
| Cosmic | Phase facade | False binding | Illusion breaks |

---

## Diagnostic Checklist

Technical tests:
- [ ] Intermediate layer audit at each k
- [ ] Reveal masked Voids: λV variation
- [ ] Phase stress test: jitter/timeout
- [ ] Deep state verification

Humane tests:
- [ ] Check below surface appearance
- [ ] Test under real stress
- [ ] Verify deep connections
- [ ] Challenge assumptions

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical layer checks nor experiential depth probes alone captures its full meaning.

---

## See Also

- [[Stable Form (classification)]]
- [[Collapsed Form (classification)]]
- [[Pseudo Form (classification)]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented